<?php
abstract class EarkSipPatientBase
{
    abstract public function __construct($patientId);

    abstract public function addFile($sourcePath, $destinationPath);

    abstract public function files();

    abstract public function addSchemaFile($filePath);

    abstract public function produceSip($outBaseDirectory, $index);

    abstract public function error();

    abstract public function patientId();

    abstract public function documentation();
    
    abstract public function addDocumentation($filePath);

    abstract public function isDocumentation($path);

    abstract public function descriptiveMetadata();

    abstract public function addDescriptiveMetadata($filePath);

    abstract public function isDescriptiveMetadata($path);

    abstract public function preservationMetadata();
    
    abstract public function addPreservationMetadata($filePath);

    abstract public function isPreservationMetadata($path);
}

abstract class EarkSipBase
{
    abstract public function __construct($transferName='');

    abstract public function createNewPatient($patientId);

    abstract public function transferName();

    abstract public function setTransferName($name);

    abstract public function addPackageMetadata($key, $value);

    abstract public function addPatient($patient);

    abstract public function isPatientDirectory($path);

    abstract public function submissionAgreements();

    abstract public function addSubmissionAgreement($filePath);

    abstract public function descriptiveMetadata();

    abstract public function addDescriptiveMetadata($filePath);

    abstract public function preservationMetadata();

    abstract public function addPreservationMetadata($filePath);

    abstract public function schemaFiles();

    abstract public function addSchemaFile($filePath);

    abstract public function produceSip(&$outPath, $outBaseDirectory);

    abstract public function error();

    abstract public function isSubmissionAgreement($path);

    abstract public function isDocumentation($path);

    abstract public function isDescriptiveMetadata($path);

    abstract public function isPreservationMetadata($path);
}
?>
