<?php
date_default_timezone_set('Europe/Oslo');
$configuration = new Configuration();
$configuration->add("SshHostname", "_PRODUCTION_SYSTEM_HOSTNAME_");
$configuration->add("SshUsername", "other-user");
$configuration->add("SshPubkeyFile", "_APPLICATION_DIR_\\keys\\id_rsa.pub");
$configuration->add("SshPrivkeyFile", "_APPLICATION_DIR_\\keys\\id_rsa");
$configuration->add("SshPrivkeyPassword", "_PRIVATE_KEY_PASSWORD_");
$configuration->add("SshDestinationDir", "/data/ut");
$configuration->add("SshPort", 22);
$configuration->add("VerifyUploadChecksum", true);
$configuration->add("RenameUploadedFile", true);
$configuration->add("OutputArchiveFormat", OUTPUT_ARCHIVE_FORMAT_TAR);
$configuration->add("OutputFormat", OUTPUT_FORMAT_NOO_OTHER);
$configuration->add("CommitAckMethod", COMMIT_ACK_METHOD_NONE);

$configuration->add("LogDir", "_LOG_DIR_");
$configuration->add("LogDebug", true);
$configuration->add("LogInfo", true);
$configuration->add("LogWarning", true);
$configuration->add("LogError", true);
$configuration->add("FileSendMethod", FILE_SEND_METHOD_SSH);
$configuration->add("SenderMaxRetries", 5);
$configuration->add("SenderFailDelay", 5);
$configuration->add("MetadataOutputFormat", METADATA_OUTPUT_FORMAT_DUBLINCORE_CSV);

function outputArchiveFileName($filePaths)
{
    global $configuration;
    global $archiveFiles;
    $fileName = "other-sip-" . basename($archiveFiles[0]) . ".mft";
    return $fileName;
}

function outputArchiveFinalName($filePaths)
{
    global $configuration;
    global $archiveFiles;
    $fileName = "other-sip-" . basename($archiveFiles[0]) . ".tar";
    return $fileName;
}

?>
