<?php
include_once("includes/error-handler.php");
include_once("includes/metadata-description-header.php");


// Settings
//

// Get current date
$currentDate = date("Y-m-d");

// Set input field size
$fieldWidth = 300;

// Set label font size
$labelFontSize = 14;

// Set text font size
$textFontSize = 14;


// Define groups
//

$metadataGroup = new MetadataTemplateItemGroup("metadata", "Metadata");

// Define metadata
//

// Contributor
$item = new MetadataTemplateItemString("contributor", "Bidragsyter", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Coverage
$item = new MetadataTemplateItemString("coverage", "Dekning", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Creator
$item = new MetadataTemplateItemString("creator", "Skapere", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Date
$item = new MetadataTemplateItemDatetime("date", "Dato", $currentDate);
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$item->setFormat("yyyy-MM-dd");
$item->setMaxDate(date("Y"), date("m"), date("d"));
$item->setMinDate("500", date("01"), date("01"));
$item->enableCalendar(true);
$metadataGroup->addItem($item);

// Description
$item = new MetadataTemplateItemString("description", "Beskrivelse", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Format
$item = new MetadataTemplateItemString("format", "Format", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Identifier
$item = new MetadataTemplateItemString("identifier", "Identifikator", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Language
$item = new MetadataTemplateItemString("language", "Språk", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Publisher
$item = new MetadataTemplateItemString("publisher", "Utgiver", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Relation
$item = new MetadataTemplateItemString("relation", "Forhold", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Rights
$item = new MetadataTemplateItemString("rights", "Rettigheter", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Source
$item = new MetadataTemplateItemString("source", "Kilde", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Subject
$item = new MetadataTemplateItemString("subject", "Emne", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Title
$item = new MetadataTemplateItemString("title", "Tittel", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Type
$item = new MetadataTemplateItemString("type", "Type", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Add groups
//

$metadataTemplate->addGroup($metadataGroup);


include_once("includes/metadata-description-footer.php");
?>
