<?php
include_once("includes/error-handler.php");
include_once("includes/metadata-description-package-header.php");


// Settings
//

// Get current date
$currentDate = date("Y-m-d");

// Set input field size
$fieldWidth = 300;

// Set label font size
$labelFontSize = 14;

// Set text font size
$textFontSize = 14;

// Functions
//
function generateIdentifier()
{
    return "inc" . rand(10000, 99999);
}

// Define groups
//

$metadataGroup = new MetadataTemplateItemGroup("metadata", "Metadata");
$databaseinfoGroup = new MetadataTemplateItemGroup("databaseinfo", "Databaseinfo");

// Define metadata
//

// Avleveringsidentifikator
$item = new MetadataTemplateItemString("avleveringsidentifikator", "Deponeringsidentifikator", generateIdentifier());
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(false);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Avleveringsidentifikator (referanse)
$item = new MetadataTemplateItemString("avleveringsbeskrivelse_deponeringsreferanse", "Deponeringsidentifikator", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Avtaleidentifikator
$item = new MetadataTemplateItemString("avtaleidentifikator", "Avtaleidentifikator", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(false);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Date
$item = new MetadataTemplateItemDatetime("avtaledato", "Avtaledato", $currentDate);
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(false);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$item->setFormat("yyyy-MM-dd");
$item->setMaxDate(date("Y"), date("m"), date("d"));
$item->setMinDate("500", date("01"), date("01"));
$item->enableCalendar(true);
$metadataGroup->addItem($item);

// Avtalebeskrivelse
$item = new MetadataTemplateItemString("avtalebeskrivelse", "Avtalebeskrivelse", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(false);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Virksomhetsnavn
$item = new MetadataTemplateItemString("virksomhetsnavn", "Behandlernavn", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Organisasjonsnummer
$item = new MetadataTemplateItemString("organisasjonsnummer", "Behandleridentifikator", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Arkivskaper
$item = new MetadataTemplateItemString("arkivskaper", "Avleverer", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Spesialisthelsetjeneste
$item = new MetadataTemplateItemDropdown("spesialisthelsetjeneste", "Spesialisthelsetjeneste", "false");
$item->addOption("Ja", "true");
$item->addOption("Nei", "false");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Type
$item = new MetadataTemplateItemDropdown("avleveringsbeskrivelse_type", "Type", "databasedump");
$item->addOption("Databasedump", "databasedump");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Dbid
$item = new MetadataTemplateItemString("avleveringsbeskrivelse_dbid", "Dbid", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$databaseinfoGroup->addItem($item);

// Date
$item = new MetadataTemplateItemDatetime("avleveringsbeskrivelse_generertdato", "Generertdato", $currentDate);
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$item->setFormat("yyyy-MM-dd");
$item->setMaxDate(date("Y"), date("m"), date("d"));
$item->setMinDate("500", date("01"), date("01"));
$item->enableCalendar(true);
$databaseinfoGroup->addItem($item);

// Jsyslev
$item = new MetadataTemplateItemString("avleveringsbeskrivelse_jsyslev", "Jsyslev", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$databaseinfoGroup->addItem($item);

// Jsysnavn
$item = new MetadataTemplateItemString("avleveringsbeskrivelse_jsysnavn", "Jsysnavn", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$databaseinfoGroup->addItem($item);

// Jsysver
$item = new MetadataTemplateItemString("avleveringsbeskrivelse_jsysver", "Jsysver", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$databaseinfoGroup->addItem($item);

// Dbtype
$item = new MetadataTemplateItemString("avleveringsbeskrivelse_dbtype", "Dbtype", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$databaseinfoGroup->addItem($item);

// Dbsize
$item = new MetadataTemplateItemString("avleveringsbeskrivelse_dbsize", "Dbsize", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$databaseinfoGroup->addItem($item);

// Merknad
$item = new MetadataTemplateItemString("avleveringsbeskrivelse_merknad", "Merknad", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$databaseinfoGroup->addItem($item);

// Add groups
//

$packageMetadataTemplate->addGroup($metadataGroup);
$packageMetadataTemplate->addGroup($databaseinfoGroup);

include_once("includes/metadata-description-package-footer.php");
?>
