<?php
include_once("includes/metadata-description-package-header.php");


// Settings
//

// Get current date
$currentDate = date("Y-m-d");

// Set input field size
$fieldWidth = 300;

// Set label font size
$labelFontSize = 14;

// Set text font size
$textFontSize = 14;


// Define groups
//

$metadataGroup = new MetadataTemplateItemGroup("metadata", "Metadata");


// Define metadata
//

// Avleveringsidentifikator
$item = new MetadataTemplateItemString("avleveringsidentifikator", "Avleveringsidentifikator", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Avleveringsbeskrivelse
$item = new MetadataTemplateItemString("avleveringsbeskrivelse", "Avleveringsbeskrivelse", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Avtaleidentifikator
$item = new MetadataTemplateItemString("avtaleidentifikator", "Avtaleidentifikator", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Date
$item = new MetadataTemplateItemDatetime("avtaledato", "Avtaledato", $currentDate);
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$item->setFormat("yyyy-MM-dd");
$item->setMaxDate(date("Y"), date("m"), date("d"));
$item->setMinDate("500", date("01"), date("01"));
$item->enableCalendar(true);
$metadataGroup->addItem($item);

// Avtalebeskrivelse
$item = new MetadataTemplateItemString("avtalebeskrivelse", "Avtalebeskrivelse", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Virksomhetsnavn
$item = new MetadataTemplateItemString("virksomhetsnavn", "Virksomhetsnavn", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Foretaksnavn
$item = new MetadataTemplateItemString("foretaksnavn", "Foretaksnavn", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Organisasjonsnummer
$item = new MetadataTemplateItemString("organisasjonsnummer", "Organisasjonsnummer", "");
$item->setWidth($fieldWidth);
$item->setReadOnly(false);
$item->setVisible(true);
$item->setLabelFontSize($labelFontSize);
$item->setFontSize($textFontSize);
$metadataGroup->addItem($item);

// Add groups
//

$packageMetadataTemplate->addGroup($metadataGroup);

include_once("includes/metadata-description-package-footer.php");
?>
