<?php
date_default_timezone_set('Europe/Oslo');
$configuration = new Configuration();
$configuration->add('VerifyUploadChecksum', false);
$configuration->add('OutputArchiveFormat', OUTPUT_ARCHIVE_FORMAT_TAR);
$configuration->add('OutputFormat', OUTPUT_FORMAT_NHA_OTHER);
$configuration->add('LogDir', sys_get_temp_dir());
$configuration->add('CommitAckMethod', COMMIT_ACK_METHOD_NHA_OTHER);
$configuration->add('LogDebug', false);
$configuration->add('LogInfo', true);
$configuration->add('LogWarning', true);
$configuration->add('LogError', true);
$configuration->add('FileSendMethod', FILE_SEND_METHOD_SSH);
$configuration->add('SenderMaxRetries', 0);
$configuration->add('SenderFailDelay', 1);
$configuration->add('MetadataOutputFormat', METADATA_OUTPUT_FORMAT_DUBLINCORE_CSV);

$configuration->add('ProductionServerAddress', '_PRODUCTION_HOSTNAME_');
$configuration->add('SshHostname', '_PRODUCTION_HOSTNAME_');
$configuration->add('SshUsername', '_SSH_USERNAME_');
//$configuration->add('SshPassword', '');
$configuration->add('SshPubkeyFile', '_APPLICATION_DIR_\keys\id_rsa.pub');
$configuration->add('SshPrivkeyFile', '_APPLICATION_DIR_\keys\id_rsa');
$configuration->add('SshPrivkeyPassword', '_PRIV_KEY_PASSWORD_');
$configuration->add('SshDestinationDir', '/data/ut/other-sip');
$configuration->add('SshPort', 22);

function outputArchiveFileName($filePaths)
{
    global $configuration;
    global $archiveFiles;

    $fileName = "other-sip-" . basename($archiveFiles[0]) . ".mft";

    return $fileName;
}
?>
